'Programm:   Foxy006_2022.bas fr Fuchsjagd-Sender mit ATtiny2313
'
'            Vollwertiges Fuchsjagd-Programm mit 22+1 whlbaren Rufzeichen und zwei
'            verschiedenen Pausen-Modi: Keine Pause zwischen den rufzeichen oder Pausen mit
'            pseudozuflliger Lnge zwischen 30sec und 3min.
'
'            Peilwettkampf-Rufzeichen laut deutschem Amateurfunkgesetz: MO,MOE,MOI,MOS,MOH,MO5.
'            Weitere Peil-Rufzeichen, die zum Teil international gebruchlich sind oder waren, aber
'            nicht in der deutschen Amateurfunkordung erwhnt werden: MOT,MOM,MOO,MOA,MOU,MOV,MO4,MON,
'            MOG,MOK,MOR,MOC,MOF,MOL,MOQ,MOX,MO9.
'            Die Einstellung erfolgt ber Pin 13 (PB1 am AVR); er wird mit einem Taster
'            oder einem Stck Draht so lange nach nach Gnd (Masse) gezogen, bis das gewnschte
'            Rufzeichen zu hren ist. Dann Taste sofort loslassen. Die Einstellung wird
'            dauerhaft (auch ohne Batterie im EEPROM) gespeichert. Die Reihenfolge ist
'            MO,MOE,MOI,MOS,MOH,MO5,MOT,MOM,MOO,MOA,MOU,MOV,MO4,MON,MOG,MOK,MOR,MOC,MOF,MOL,MOQ,MOX,MO9
'            und dann wieder von vorn.
'            Auerdem sind ber Pin 14(PB2 am AVR) zwei Arten Pause einstellbar. Entweder wird
'            permanent das Rufzeichen OHNE PAUSE ausgesendet (Einstellung 1) oder als
'            Einstellung 2 werden die Rufzeichen je 5 mal ausgesendet und danach erfolgt eine
'            Sendepause mit pseudo-zuflliger Lnge zwischen 30 Sekunden und 3 Minuten. Dann
'            wird wieder 5 mal das Rufzeichen gesendet u.s.w.
'            Einstellung der Pausen-Art: ber Pin 14 (PB2 am AVR); er wird mit einem Taster
'            oder einem Stck Draht so lange nach nach Gnd (Masse) gezogen, bis entweder
'            ein Dauerton zu hren ist oder ein sirrender Ton. Ein Dauerton zeigt an, da
'            keine Pausen zwischen den Rufen gemacht werden und der sirrende Ton zeigt an, da
'            Pausen zuflliger Lnge gemacht werden.
'
'Von:        Roland Walter, DL7UNO, www.rowalt.de
'Modifiziert Armin Duft, DH1DA, www.e-duft.de
'Sprache:    Bascom-AVR-Basic, siehe www.mcselec.com
'Datum:      23.05.2022 (letzte nderung)
'
'Hardware:   PB1 Eing. Rufzeichen, PB2 Eing. Pausenmode
'            PD3 Sendertastung
'
'            Fusebits: externer Quarz, Clock Divide by 8
 $prog &HFF , &H5C , &HDF , &HFF                            ' Fuses programmieren LOCK, LOW, HIGH, EXT
'-------------------------------------------------------------------------------
'Grundeinstelllungen:
$regfile = "ATtiny2313.dat"                                 'Deklarationen fr den ATtiny2313 einbinden
$crystal = 448750                                           'Taktfrequenz: 3,579 MHz (XTAL mit Vorteilung 1/8)
'- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
'Einstellbare Werte je nach Geschmack:
Const Len_dit = 80                                          'Lnge eines Punkts, daraus ergibt sich die Morsegeschwindigkeit
Const Len_da = Len_dit * 3                                  'Lnge eines Strichs (soll 3*Punkt sein)
Const Len_pause = Len_dit * 6                               'Lnge der Pause zwischen den 5er-Gruppen (optimal: 6 Punkt-Lngen)
Const Tone_frequ = 140                                      'Tonfrequenz, Wert 140 ergab sich beim Ausprobieren als recht brauchbar
'- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
'Die folgenden Konstanten nehmen den binren Code fr das betreffende Morsezeichen
'auf. Konstanten bentigen brigens KEINEN Platz im Flash, sie sind lediglich eine
'Art "bersetzungsanweisung" fr den Compiler. Die Erluterung fr die Codierung
'befindet sich ganz unten im Listing.
Const Morse_a = 18 : Const Morse_b = 12 : Const Morse_c = 44 : Const Morse_d = 11 : Const Morse_e = 1
Const Morse_f = 36 : Const Morse_g = 27 : Const Morse_h = 4 : Const Morse_i = 2 : Const Morse_j = 116
Const Morse_k = 43 : Const Morse_l = 20 : Const Morse_m = 26 : Const Morse_n = 10 : Const Morse_o = 59
Const Morse_p = 52 : Const Morse_q = 92 : Const Morse_r = 19 : Const Morse_s = 3 : Const Morse_t = 9
Const Morse_u = 35 : Const Morse_v = 68 : Const Morse_w = 51 : Const Morse_x = 76 : Const Morse_y = 108
Const Morse_z = 28
Const Morse_ae = 84 : Const Morse_oe = 68 : Const Morse_ue = 100 : Const Morse_ch = 4
Const Morse_null = 253 : Const Morse_1 = 245 : Const Morse_2 = 229 : Const Morse_3 = 197 : Const Morse_4 = 133
Const Morse_5 = 5 : Const Morse_6 = 13 : Const Morse_7 = 29 : Const Morse_8 = 61 : Const Morse_9 = 125
Const Morse_stroke = 141                                    '"-"
Const Morse_slash = 77                                      '"/"
'
'Die folgenden Konstanten definieren die Pausenarten, die der Anwender whlen kann:
Const Pause_null = 0                                        'Rufzeichen ohne Pause aussenden
Const Pause_rand = 1                                        'Rufzeichen mit pseudozuflliger Pause dazwischen aussenden
'- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
'Variablen dimensionieren:
Dim I As Byte                                               'Fr temporren Gebrauch im Hauptprogramm
Dim Charno As Byte                                          'Aktueller Morsebuchstabe
Dim Bitno As Byte                                           'Zhlt die Code-Bits des aktuellen Morsebuchstabens hoch
Dim Lencurtext As Byte                                      'Lnge des aktuell zu sendenden Rufzeichens in Zeichen (MO=2, MOS=3)
Dim Randpauselen As Byte                                    'Zhler fr aktuelle Pausenlnge, wenn zufllige Pausenlngen eingestellt
Dim Randcalls As Byte                                       'Zhler fr die Anzahl der zu sendenden Rufzeichen zwischen den Pausen, wenn zufllige Pausenlngen eingestellt
Dim Eecurcallsign As Eram Byte                              'Aktuell eingestelltes Rufzeichen (0=MO,1=MOE,2=MOI....)
Dim Eecurpauseid As Eram Byte                               'Aktuell eingestellte Pausenart (Konstante PAUSE_...)
Dim Finitdone As Bit                                        'Ist beim Start Null, ist 1, wenn Initialisierungsroutinen komplett durchlaufen
Dim Weerndinit As Eram Word                                 'Initialisierungswert fr den Pseudo-Zufallsgenerator im EEPROM
Dim ___rseed As Word                                        'Initialisierungs-Variable des Pseudo-Zufallsgenerators, siehe Bascom-Hilfe unter "Rnd()"
'- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
'Konstanten und Variablen zum Text, der gesendet werden soll:
Dim Txtext(3) As Byte                                       'Feld fr die codierten Morsebuchstaben
'- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
'Initialisierung des Programms:
'
Acsr.acd = 0                                                'Analog-Komparator ausschalten, spart etwas Strom
'
Config Portb = &B00000000                                   'kompletten Port B als 'Eingang' konfigurieren
Portb = &B00000110                                          'PullUp-Widerstnde fr die Pins PB1+PB2 aktivieren (Strfestigkeit)
Config Portd = &B00001000                                   'Pin PD3 als 'Ausgang' konfigurieren
Portd = 0                                                   'Pin auf low Pegel stellen
'
If Eecurpauseid = Pause_rand Then                           'Nur wenn pseudozufllige Pausen vom Anwender ausgewhlt wurden
  'Damit der Pseudo-Zufallsgenerator nicht jedesmal die selbe Zahlenreihe erzeugt, mssen wir ihn mit
  'einem vernderlichen Startwert fttern. Wir lsen das auf einfachste Weise, indem wir hochzhlen,
  'wie oft das Programm bereits gestartet wurde und die Bits etwas rotieren lassen. Der entstandene Wert
  'wird dann wieder im EEPROM abgelegt:
  ___rseed = Weerndinit                                     'Initialisierungswert aus dem EEPROM holen und Zufallsgenerator damit initialisieren
  Rotate ___rseed , Left , 7                                'Die Bits des Initialisierungswerts rotieren lassen...
  Incr ___rseed                                             'und den Wert um 1 erhhen. Damit sollte ein recht zuflliger Eindruck entstehen.
  Weerndinit = ___rseed                                     'Und nun den neuen Wert im EEPROM ablegen.
End If


'-------------------------------------------------------------------------------
'Hauptprogramm:
Gosub Button1pressed                                        'Simuliert Tastendruck zur Initialisierung (Rufzeichen laden)
Finitdone = 1                                               'Alle Initialisierungsroutinen komplett durchlaufen
'
Do                                                          'Hauptschleife des Programms
  'Reaktion auf Tastendrcke (Draht von Pin PB1 oder PB2 nach Gnd gezogen)
  'Hinweis: Wir brauchen hier keine Tasten-Entprellung (mit Debounce o..), weil wir an diesen Punkt nur
  'jeweils einmal nach Absenden eines kompletten Rufzeichens gelangen. Das wirkt schon ganz alleine als
  'Entprellung.
  If Pinb.1 = 0 Then Gosub Button1pressed                   'Wenn Pin PB1 (=MISO) Null Volt
  If Pinb.2 = 0 Then Gosub Button2pressed                   'Wenn Pin PB2 (=SCK) Null Volt
  '
  'Senden der Tne:
  'Bitte beachten: Wir beenden den StandBy-Zustand des MICRF102 erst unmittelbar vor Beginn eines Tons und
  'schalten den MICRF102 sofort nach Ende eines Tons wieder in den StandBy-Zustand. Das spart zum einen eine
  'Menge Strom, weil Mark und Space bei ASK voller und verminderter Trger bedeuten, d.h. auch bei Space wird
  'ein Trger gesendet! Zum zweiten erlichtern wir aber das Peilen gewaltig, wenn zwischen den Tnen kein
  'Trger stehenbleibt. Dann kann beim Peilen auch das Rauschen zwischen den Tnen zur Beurteilung herangezogen
  'werden, was insbesondere bei Empfngern mit automatischer Empfindlichkeitsregelung sehr hilfreich ist.
  For Charno = 1 To Lencurtext                              'Alle Morsebuchstaben ausgeben
    I = Txtext(charno) And &B00000111                       'Die Anzahl der Punkte/Striche ist in den unteren 3 Bits...
    I = I + 2                                               'Anzahl in hchste verwendete Bitnummer umwandeln
    For Bitno = 3 To I                                      'Bit 3...i enthlt die Punkte und Striche
      Portd.3 = 1                                           'Sendertastung ein
      If Txtext(charno).bitno = 0 Then                      'Bit nicht gesetzt: Es ist ein Punkt (dit)
        Waitms Len_dit                                      'Jetzt warten, Timer1 gibt selbstndig den Ton aus
      Else                                                  'Bit gesetzt: Es ist ein Strich (da)
        Waitms Len_da                                       'Jetzt warten, Timer1 gibt selbstndig den Ton aus
      End If
      Portd.3 = 0                                           'Sendertastung aus
      Waitms Len_dit                                        'Pause innerhalb des Morsebuchstabens
    Next Bitno
    Waitms Len_da                                           'Pause zwischen den Morsebuchataben
  Next Charno
  '
  'Pause laut Anwender-Auswahl:
  Select Case Eecurpauseid
  Case Pause_null                                           'PAUSE_NULL=0: Rufzeichen ohne Pause aussenden
    Waitms 1000                                             'Stets 1 Sekunde Pause, wenn Text komplett gesendet
  Case Else                                                 'PAUSE_RAND=1: Rufzeichen mit pseudozuflliger Pause dazwischen aussenden
    Waitms 1000                                             'Stets 1 Sekunde Pause, wenn Text komplett gesendet
    Incr Randcalls                                          'Zwischen den Pausen wird jeweils 5 mal das Rufzeichen gesendet
    If Randcalls > 4 Then                                   'Das Rufzeichen wurde 5 mal gesendet: Pause machen
      Randcalls = 0                                         'Zhler zurksetzen
      I = Rnd(150) + 30                                     'Pseudo-Zufallszahl von 30...150+30=180 fr 30sec...3min Pause
      For Randpauselen = 0 To I                             'Runden mit je einer Sekunde Pause, in denen (wichtig!) der Tasten-Status geprft wird
        Waitms 1000
        If Pinb.1 = 0 Then Exit For                         'Bei Button-Druck Schleife sofort verlassen, Auswertung siehe oben
        If Pinb.2 = 0 Then Exit For                         'Bei Button-Druck Schleife sofort verlassen, Auswertung siehe oben
      Next Randpauselen
    End If
  End Select
Loop
'------------------------------------------------------------------------------------------------------------------------------
Button1pressed:                                             'Button 1 (Pin PB1 nach Gnd) wurde gedrckt
  'Das Rufzeichen soll gendert werden. Die ID des aktuellen Rufzeichens wird stets in der
  'EEPROM-Variablen eeCurCallSign gespeichert. Abhngig vom Wert dieser Variablen wird
  'das Feld TxText() verndert, welches die Morsecodes frs Senden speichert.
  '
  Randcalls = 0                                             'Ruf-Zhler zurcksetzen, falls gerade Zufalls-Pausen aktiviert sind
  '
  Txtext(1) = Morse_m                                       'Erster Buchstabe des Rufzeichens   (bei allen Fuchs-Rufzeichen gleich)
  Txtext(2) = Morse_o                                       'Zweiter Buchstabe des Rufzeichens  (bei allen Fuchs-Rufzeichen gleich)
  Lencurtext = 3                                            'Lnge des aktuellen Rufzeichens in Zeichen (bleibt so auer bei MO)
  '
  I = Eecurcallsign                                         'Aktuelle Rufzeichen-ID vom EEPROM in Temp-Variable laden
  If Finitdone = 1 Then Incr I                              'Nchstes Rufzeichen, falls nicht Initialisierung des Programms
  If I > 22 Then I = 0                                      'Umlauf, wieder Rufzeichen MO (auch bei Fabrikzustand=255)
  '
  'Rufzeichen-Vorrat: MO,MOE,MOI,MOS,MOH,MO5,MOT,MOM,MOO,MOA,MOU,MOV,MO4,MON,MOG,MOK,MOR,MOC,MOF,MOL,MOQ,MOX,MO9
  Select Case I
  Case 0 : Lencurtext = 2                                   'MO: Sonderfall, es gibt keinen dritten Buchstaben
  Case 1 : Txtext(3) = Morse_e
  Case 2 : Txtext(3) = Morse_i
  Case 3 : Txtext(3) = Morse_s
  Case 4 : Txtext(3) = Morse_h
  Case 5 : Txtext(3) = Morse_5
  Case 6 : Txtext(3) = Morse_t
  Case 7 : Txtext(3) = Morse_m
  Case 8 : Txtext(3) = Morse_o
  Case 9 : Txtext(3) = Morse_a
  Case 10 : Txtext(3) = Morse_u
  Case 11 : Txtext(3) = Morse_v
  Case 12 : Txtext(3) = Morse_4
  Case 13 : Txtext(3) = Morse_n
  Case 14 : Txtext(3) = Morse_g
  Case 15 : Txtext(3) = Morse_k
  Case 16 : Txtext(3) = Morse_r
  Case 17 : Txtext(3) = Morse_c
  Case 18 : Txtext(3) = Morse_f
  Case 19 : Txtext(3) = Morse_l
  Case 20 : Txtext(3) = Morse_q
  Case 21 : Txtext(3) = Morse_x
  Case Else : Txtext(3) = Morse_9
  End Select
  '
  Eecurcallsign = I                                         'Aktuelle Rufzeichen-ID im EEPROM speichern
Return
'------------------------------------------------------------------------------------------------------------------------------
Button2pressed:                                             'Button 2 (Pin PB2 nach Gnd) wurde gedrckt
  'Die Pausenart zwischen den Rufzeichen-Aussendeungen soll gendert werden. Die Art der Pause wird
  'in der EEPROM-Variablen eeCurPauseID gespeichert (Konstanten PAUSE_...).  Abhngig vom Wert
  'dieser Variablen wird die Variable CurPause gsetzt.
  '
  I = Eecurpauseid                                          'Aktuelle Pausen-ID vom EEPROM in Temp-Variable laden
  Incr I                                                    'Nchste Pausen-ID
  If I > 1 Then I = 0                                       'Umlauf, wieder PAUSE_NULL (auch bei Fabrikzustand=255)
  '
  'Quittungston senden: Langer Ton fr pausenfreies Senden, sirrender Ton fr Zufalls-Pausen
  '
  Select Case I
  Case Pause_null                                           'PAUSE_NULL=0: Rufzeichen ohne Pause aussenden
    'Langer Ton als Quittung:
    Portd.3 = 1
    Waitms 3000                                             'Jetzt warten, Timer1 gibt selbstndig den Ton aus
    Portd.3 = 0
  Case Else                                                 'PAUSE_RAND=1: Rufzeichen mit pseudozuflliger Pause dazwischen aussenden
    Randcalls = 5                                           'Ruf-Zhler so setzen, da 1x das Rufzeichen gesendet wird und dann sofort Pause (vermeidet Verwirrungen)
    'Sirrender Ton als Quittung:
    For I = 0 To 50
      Portd.3 = 1
      Waitms 20                                             '20 Millisekunden warten, Timer1 gibt selbstndig den Ton aus
      Portd.3 = 0
      Waitms 20                                             '20 Millisekunden warten (Pause)
    Next I
  End Select
  '
  Eecurpauseid = I                                          'Aktuelle Pausen-ID im EEPROM speichern
  '
  'Die gewhlte Pause wird in der Hauptschleife generiert
Return
'------------------------------------------------------------------------------------------------------------------------------
End
'------------------------------------------------------------------------------------------------------------------------------
'Codierung der Morsebuchstaben (hoffentlich alle fehlerfrei):
'Jeder Morsebuchstabe wird mit einem Byte codiert. Die Bits jedes "Code"-Bytes haben folgende Bedeutung:
'1.) Die unteren 3 Bits geben an, wieviele Punkte/Striche in den oberen 5 Bits verwendet werden, wobei
'    die Werte 0, 6 und 7 unzulssig sind.
'2.) Die oberen 5 Bits sind der Borsebuchstabe selbst. Eine 0 ist ein Punkt (dit) und eine 1 ist ein
'    Strich (da). Der Beginn ist das unterste der 5 oberen Bits. Es werden nur so viele der 5 Bits
'    verwendet, wie in den untersten 3 Bits angegeben sind. Die restlichen Bits werden ignoriert.
'Hier sind einige Codes als Beispiel:
'18  dezimal ist 00010010 binr: 010 = 2 Punkte/Striche, 01    = dit da              ==> Buchstabe A
'12  dezimal ist 00001100 binr: 100 = 4 Punkte/Striche, 1000  = da dit dit dit      ==> Buchstabe B
'44  dezimal ist 10101100 binr: 100 = 4 Punkte/Striche, 1010  = da dit da dit       ==> Buchstabe C
'11  dezimal ist 00001011 binr: 011 = 3 Punkte/Striche, 100   = da dit dit          ==> Buchstabe D
'1   dezimal ist 00000001 binr: 001 = 1 Punkt/Strich,   0     = dit                 ==> Buchstabe E
'36  dezimal ist 00100100 binr: 100 = 4 Punkte/Striche, 0010  = dit dit da dit      ==> Buchstabe F
'116 dezimal ist 01110100 binr: 100 = 4 Punkte/Striche, 0111  = dit da da da        ==> Buchstabe J
'108 dezimal ist 01101100 binr: 100 = 4 Punkte/Striche, 1011  = da dit da da        ==> Buchstabe Y
'28  dezimal ist 00011100 binr: 100 = 4 Punkte/Striche, 1100  = da da dit dit       ==> Buchstabe Z
'253 dezimal ist 11111101 binr: 101 = 5 Punkte/Striche, 11111 = da da da da da      ==> Buchstabe 0
'245 dezimal ist 11110101 binr: 101 = 5 Punkte/Striche, 01111 = dit da da da da     ==> Buchstabe 1
'133 dezimal ist 10000101 binr: 101 = 5 Punkte/Striche, 00001 = dit dit dit dit da  ==> Buchstabe 4
'61  dezimal ist 00111101 binr: 101 = 5 Punkte/Striche, 11100 = da da da dit dit    ==> Buchstabe 8
'125 dezimal ist 01111101 binr: 101 = 5 Punkte/Striche, 01111 = dit dit dit dit da  ==> Buchstabe 9
'84  dezimal ist 01010100 binr: 100 = 4 Punkte/Striche, 0101  = dit da dit da       ==> Buchstabe 
'68  dezimal ist 01000100 binr: 100 = 4 Punkte/Striche, 0001  = da da da dit        ==> Buchstabe 
'100 dezimal ist 01100100 binr: 100 = 4 Punkte/Striche, 0011  = dit dit da da       ==> Buchstabe 
'4   dezimal ist 00000100 binr: 100 = 4 Punkte/Striche, 0000  = da da da da         ==> Buchstabe CH
'141 dezimal ist 10001101 binr: 101 = 5 Punkte/Striche, 10001 = da dit dit dit da   ==> Satzzeichen "-"
'77  dezimal ist 01001101 binr: 101 = 5 Punkte/Striche, 10010 = da dit dit da dit   ==> Satzzeichen "/"
'255 dezimal ist 11111111 binr: 111 = 7 Punkte/Striche, 11111 = illegal,Sondercode  ==> Pause mit Lnge Dit
'
'
'... Ihr knnt die nicht aufgefhrten Codes selbst hinzufgen als bung, da ihr es verstanden habt ;-)
'Diese Art Codierung drfte so ziemlich das effizienteste sein, was man in einem Mikrocontroller
'machen kann.
'Mit der gewhlten Codierung sind natrlich nur Morsezeichen mit 1 bis 5 Punkten/Strichen darstellbar. Aber damit
'sind ja immerhin alle Buchstaben einschlielich deutscher und anderer Sonderzeichen und die Zahlen erreicht.
'Ein Problem sind aber die 6stelligen Satzzeichen und die 8stellige Irrung. Hierfr kann man die "illegalen"
'Lngenangaben 0, 6 und 7 nutzen.
'So knnte man z.B. vereinbaren, da bei einer Lngenangabe von 6 erst ein dit gesendet wird und dann die Bits, die
'im oberen 5-Bit-Block codiert sind. Frs Fragezeichen "dit dit da da dit dit" codiert man also "dit da da dit dit"
'mit Lngenangabe 6. Entsprechend gibt eine Lngenangabe von 7 an, da erst ein da gesendet wird und dann die Bits,
'die im oberen 5-Bit-Block codiert sind. Frs Komma "da da dit dit da da" codiert man also "da dit dit da da" mit
'Lngenangabe 7. Diese Art der Erweiterung ist softwareseitig sehr einfach umsetzbar.
'Damit haben wir bis auf eine einzige Ausnahme alle Zeichen erfat, denn auer zusammengesetzten Zeichen gibt es
'keine Morsezeichen, die mehr als 6 Stellen haben. Was uns noch fehlt, ist die Irrung mit 8 mal dit. Hier knnten
'wir die Lngenangabe 0 verwenden, der wir die Bedeutung geben, alle 8 Bits des Codes als Stellen des Morsezeichens
'anzusehen und auszusenden. Bei der Irrung setzen wir also Code 0, was dann 8 mal dit ergibt. Auch das ist
'softwareseitig gut umsetzbar. Da sich hierbei als reine Mglichkeit ein Reihe von 8stelligen Morsezeichen ergeben,
'die man gar nicht bentigt, kann die Lngenangabe 0 natrlich auch genutzt werden, um beliebige Steuerkommandos
'zu codieren - etwa um ein Funkgert auf Senden zu schalten oder irgend etwas anderes zu tun.
